// Copyright 2005-2006 Adobe Macromedia Software LLC and its licensors. All rights reserved.

var HELP_DOC = MM.HELP_cmdSpryXMLDataSetTest;

var _dataSetName	= null;
var _xmlSource = null;
var _xmlSchemaTree = null;
var _dataSetColList = null;
var _dataSetSortColList = null;
var _dataTypeList = null;
var _xPathExpr = null;
var _dataPreviewHolder = null;

//design time ajax data set
var anAjaxDataSet = null;
var treeNodeContents = "";

//*************************API**************************

//--------------------------------------------------------------------
// FUNCTION:
//   commandButtons
//
// DESCRIPTION:
//   Returns the array of buttons that should be displayed on the
//   right hand side of the dialog.  The array is comprised
//   of name, handler function name pairs.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   array of strings - name, handler function name pairs
//--------------------------------------------------------------------

function commandButtons()
{                          
  return new Array(MM.BTN_OK,     "okClicked()");
}

//--------------------------------------------------------------------
// FUNCTION:
//   okClicked
//
// DESCRIPTION:
//   Sets the return value to the selected DSN and closes the window.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------

function okClicked()
{
  var retVal = new Array();
  window.close();
}

//--------------------------------------------------------------------
// FUNCTION:
//   cancelClicked
//
// DESCRIPTION:
//   Closes the window and returns nothing
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------

function cancelClicked()
{
  dwscripts.setCommandReturnValue("");
  window.close();
}



//--------------------------------------------------------------------
// FUNCTION:
//   initializeUI
//
// DESCRIPTION:
//   This function is called in the onLoad event.  It is responsible
//   for initializing the UI.  If we are inserting a recordset, this
//   is a matter of populating the connection drop down.
//
//   If we are modifying a recordset, this is a matter of inspecting
//   the recordset tag and setting all the form elements.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------

function initializeUI()
{
  _dataPreviewHolder = dwscripts.findDOMObject("dataPreview"); 
  var cmdArgs = dwscripts.getCommandArguments();
  if (cmdArgs && cmdArgs.length)
  {
	//get the xml source and xpath reference
	var xmlSource = cmdArgs[0];
	var xPathRef  = cmdArgs[1];
	var schemaNameArray = cmdArgs[2];
	var selfReferenceNode = cmdArgs[3];
	var dsName = cmdArgs[4];
	//fix for dynamic feed
	if (ajaxUtils.isDynamicFeed(xmlSource))
	{
		xmlSource = ajaxUtils.fixDynamicFeed(xmlSource);
	}
	var anAjaxDataSet = new ajaxDesignTimeDataSet(dsName,xmlSource,xPathRef);
	if (anAjaxDataSet)
	{
		//generate the table for sample data
		var dataPreviewContents = anAjaxDataSet.generateSampleDataTree(schemaNameArray, selfReferenceNode);
		if (dataPreviewContents && dataPreviewContents.length)
		{
			_dataPreviewHolder.innerHTML = dataPreviewContents;
		}
	}
  }
}



//--------------------------------------------------------------------
// FUNCTION:
//   displayHelp
//
// DESCRIPTION:
//   Displays the built-in Dreamweaver help.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------

function displayHelp()
{
  // Replace the following call if you are modifying this file for your own use.
	dwscripts.displayDWHelp(HELP_DOC);
}
